package com.elitesland.pur.common.inter.impl;

import com.elitesland.pur.common.inter.PurInter;
import com.elitesland.pur.common.inter.PurPushRecordRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
public class NoopPurRetryRecordRepository implements PurPushRecordRepository {
    private static final Logger logger = LoggerFactory.getLogger(NoopPurRetryRecordRepository.class);

    @Override
    public void saveFailRecord(PurInter inter, Long docId, String docNo, String errorMsg) {
        logger.warn("未找到有效的可重推的失败记录持久化方法: {}, {}, {}", inter, docNo, docId);
    }

    @Override
    public Long savePushRecord(PurInter inter, String docNo, Long docId, Map<String, String[]> queryParams, Object reqBody, boolean reqSuccess, LocalDateTime reqTime, Object respBody, String errorMsg) {
        logger.warn("未找到有效的可重推的推送记录持久化方法: {}, {}, {}, {}", inter, docNo, docId, errorMsg);
        return null;
    }
}
