package com.elitesland.pur.dto.po;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/25 周三
 */
@Getter
@Setter
public class PurPoSuppPriceUpdateDTO implements Serializable {
    private static final long serialVersionUID = 3759743293271818444L;

    @ApiModelProperty(value = "采购订单编号")
    private String docNo;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "订单明细信息")
    private List<PurPoD> purPoDList;

    @Getter
    @Setter
    public static class PurPoD implements Serializable {
        private static final long serialVersionUID = -3855423169847462802L;

        @ApiModelProperty(value = "物料编码")
        private String itemCode;

        @ApiModelProperty(value = "不含税单价")
        private BigDecimal netPrice;

        @ApiModelProperty(value = "含税单价")
        private BigDecimal price;

        @ApiModelProperty(value = "税率")
        private BigDecimal taxRate;

        @ApiModelProperty(value = "税额")
        private BigDecimal taxAmt;

        @ApiModelProperty(value = "含税金额")
        private BigDecimal amt;

        @ApiModelProperty(value = "不含税金额")
        private BigDecimal netAmt;
    }
}
