package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "退货申请单")
public class PurRnsRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("发货仓库")
    private Long fromWhId;

    @ApiModelProperty("收货供应商")
    private Long suppId;

    @ApiModelProperty("收货供应商")
    private String suppCode;

    @ApiModelProperty("收货供应商")
    private String suppName;

    @ApiModelProperty("状态")
    private String docStatus;

    @ApiModelProperty("关联单据2编码")
    private String relateDoc2No;

    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;

    private Long relateDocId;

    @ApiModelProperty("关联单据编码")
    private String relateDocNo;

    @ApiModelProperty("关联单据ID")
    private String rootDocCls;

    private Long rootDocId;

    private String rootDocNo;

    @ApiModelProperty("储值账户金额")
    private BigDecimal storedAmt;

    @ApiModelProperty("信用账户金额")
    private BigDecimal creditAmt;

    @ApiModelProperty("返利账户金额")
    private BigDecimal rebateAmt;

    @ApiModelProperty("储值账户累计金额")
    private BigDecimal storedReturnAddAmt;

    @ApiModelProperty("返利账户累计金额")
    private BigDecimal rebateReturnAddAmt;

    @ApiModelProperty("信用账户累计金额")
    private BigDecimal creditReturnAddAmt;


    private List<PurRnsDRpcDTO> rnsDRpcDTOS;

    private String pics;
}