package com.elitesland.pur.common.inter.impl;

import com.elitescloud.boot.util.JSONUtil;
import com.elitesland.pur.common.inter.PurInter;
import com.elitesland.pur.common.inter.bip.PurBipPushClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.validation.constraints.NotNull;
import java.util.function.Consumer;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/21 周一
 */
public class NoopPurBipPushClient implements PurBipPushClient {
    private static final Logger logger = LoggerFactory.getLogger(NoopPurBipPushClient.class);

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public String push(PurInter inter, @NotNull Long docId, String docNo, Object reqBody, Consumer<Long> pushRecordConsumer) {
        logger.info("未推送接口{}，单据{}，请求参数{}", inter, docNo, reqBody);
        return null;
    }

    @Override
    public String toJsonString(Object obj) {
        return JSONUtil.toJsonString(obj);
    }
}
