package com.elitesland.pur.provider;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.ss.PurSsCreateByPoDTO;
import com.elitesland.pur.dto.ss.PurSsDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + PurSsProvider.PATH)
public interface PurSsProvider {
    String PATH = "/purSs";

    @PostMapping("/updateCarrierInfo")
    ApiResult<Void> updateCarrierInfo(@RequestBody PurSsDTO param);

    @PostMapping("/updateIsCarrige")
    ApiResult<Void> updateIsCarrige(@RequestBody PurSsDTO param);

    /**
     * 根据采购订单创建发货单
     *
     * @param poDTO
     * @return
     */
    @PostMapping(value = "/createByPo")
    ApiResult<String> createByPurPo(@RequestBody PurSsCreateByPoDTO poDTO);
}
