package com.elitesland.pur.dto.ss;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/25 周三
 */
@Getter
@Setter
public class PurSsCreateByPoDTO implements Serializable {
    private static final long serialVersionUID = -8198743762224826888L;

    @ApiModelProperty(value = "采购订单编号", required = true)
    private String purPoDocNo;

    @ApiModelProperty(value = "来源单号", required = true)
    private String sourceDocNo;

    @ApiModelProperty(value = "发货日期", required = true)
    private LocalDateTime shipmentDate;

    @ApiModelProperty(value = "预计到货日期", required = true)
    private LocalDateTime etaDate;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "仓库编码")
    private String whCode;

    @ApiModelProperty(value = "发货联系人")
    private String shipmentContactName;
    @ApiModelProperty(value = "发货联系电话")
    private String shipmentContactTel;

    @ApiModelProperty(value = "发货地-国家")
    private String shipmentCountry;
    @ApiModelProperty(value = "发货地-省")
    private String shipmentProvince;
    @ApiModelProperty(value = "发货地-市")
    private String shipmentCity;
    @ApiModelProperty(value = "发货地-区")
    private String shipmentCounty;
    @ApiModelProperty(value = "发货地-详细地址")
    private String shipmentDetailaddr;

    @ApiModelProperty(value = "快递类型编码")
    private String expressTypeCode;
    @ApiModelProperty(value = "快递类型名称")
    private String expressTypeName;
    @ApiModelProperty(value = "物流单号")
    private String logisticsNo;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "发货单明细")
    private List<PurSsD> purSsDList;

    @Getter
    @Setter
    public static class PurSsD implements Serializable {
        private static final long serialVersionUID = -7302876670403613311L;

        @ApiModelProperty(value = "物料编号")
        private String itemCode;

        @ApiModelProperty(value = "发货数量")
        private BigDecimal qty;

        @ApiModelProperty(value = "行号")
        private BigDecimal lineNo;

        @ApiModelProperty(value = "备注")
        private String remark;
    }
}
