package com.elitesland.pur.dto.po;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "采购订单在线支付返回")
public class PurPoOnlinePayRpcDTO implements Serializable {
    private static final long serialVersionUID = 402129355488680789L;

    @ApiModelProperty("采购订单ID")
    private Long poId;

    @ApiModelProperty("采购订单号")
    private String poNo;

    @ApiModelProperty("在线支付单号")
    private String onlinePayOrderNo;

    @ApiModelProperty("在线支付时间")
    private LocalDateTime onlinePayTime;

    @ApiModelProperty("在线支付金额")
    private BigDecimal onlinePayAmt;

    @ApiModelProperty("在线支付标识")
    private Boolean onlinePayFlag;

    @ApiModelProperty("采购订单明细信息")
    private List<PoItem> poItems;

    @Data
    public static class PoItem implements Serializable {

        private static final long serialVersionUID = 4817802496174323675L;

        @ApiModelProperty(value = "商品id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long itemId;

        @ApiModelProperty(value = "商品编码")
        private String itemCode;

        @ApiModelProperty(value = "商品名称")
        private String itemName;

        @ApiModelProperty(value = "采购数量")
        private BigDecimal qty;

        @ApiModelProperty("销售含税金额")
        private BigDecimal lastPathSaleAmt;

    }
}
