package com.elitesland.pur.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 有价商品查询参数
 *
 * @author chaofeng.xia
 * @date 2023/10/9 13:07
 */
@Data
@ApiModel(value = "PurPriceItemParamRpcDTO", description = "有价商品查询")
public class PurPriceItemParamRpcDTO implements Serializable {

    @ApiModelProperty("公司ID")
    @NotNull(message = "公司ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("供应商ID")
    @NotNull(message = "供应商ID不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;


}
