package com.elitesland.pur.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.pur.Application;
import com.elitesland.pur.dto.PurSuppSyncDTO;
import com.elitesland.pur.dto.supp.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/25
 */
@FeignClient(name = Application.NAME, path = Application.PATH + PurSuppProvider.PATH)
@Validated
public interface PurSuppProvider {
    String PATH = "/purSupp";

    /**
     * 增加归属公司信息到供应商
     */
    @PostMapping("/appendOu")
    ApiResult<String> appendOu(@RequestBody PurSuppOuAddRpcDTO param);

    /**
     * 根据入参查询供应商基础信息列表
     *
     * @param param 入参
     * @return 供应商基础信息出参对象列表
     */
    @GetMapping("/findBaseRpcDto")
    ApiResult<List<PurSuppBaseRpcDTO>> findBaseRpcDtoByParam(@RequestBody PurSuppBaseRpcParam param);

    @GetMapping("/findSuppInvRpcDto")
    ApiResult<List<PurSuppBaseRpcDTO>> findSuppInvByParam(@RequestBody PurSuppBaseRpcParam param);

    /**
     * 根据入参查询供应商的银行信息列表
     *
     * @param param 入参
     * @return 供应商的银行信息出参对象列表
     */
    @GetMapping("/findBankAccRpcDto")
    ApiResult<List<PurSuppBankAccRpcDTO>> findBankAccRpcDtoByParam(@RequestBody PurSuppBankAccRpcParam param);

    /**
     * 根据入参查询供应商的联系信息列表
     *
     * @param param 入参
     * @return 供应商的联系信息出参对象列表
     */
    @GetMapping("/findAddressRpcDto")
    ApiResult<List<PurSuppAddressRpcDTO>> findAddressRpcDtoByParam(@RequestBody PurSuppAddressRpcParam param);

    /**
     * 根据入参查询供应商的资质证照
     *
     * @param param 入参
     * @return 供应商的联系信息出参对象列表
     */
    @GetMapping("/findQualifyRpcDto")
    ApiResult<List<PurSuppQualifyRpcDTO>> findQualifyRpcDtoByParam(@RequestBody PurSuppQualifyRpcParam param);

    /**
     * 根据供应商入参分页查询供应商部分信息
     *
     * @param param 供应商DTO入参
     * @return 供应商部分信息出参对象
     */
    //ApiResult<PagingVO<PurSuppBaseDTO>> searchSupp(PurSuppParamDTO param);

    /**
     * 根据ID批量查询供应商信息
     *
     * @param ids 供应商ID
     * @return 供应商对象
     */
    @PostMapping("/findBySuppIdBatch")
    ApiResult<List<PurSuppBaseDTO>> findBySuppIdBatch(@RequestBody List<Long> ids);

    /**
     * 根据供应商ID查询其银行信息
     *
     * @param id 供应商ID
     * @return 供应商的银行信息
     */
    @PostMapping("/findBankBySuppId")
    ApiResult<PurAddrBankAccDTO> findBankBySuppId(@RequestBody Long id);

    /**
     * 创建供应商发货单
     */
    @PostMapping("/createPurSs")
    ApiResult<Void> createPurSs(@RequestBody PurSsRpcParam param);

    @PostMapping("/findSimpleRpcDto")
    ApiResult<List<PurSuppBaseRpcDTO>> findSimpleRpcDtoByParam(@RequestBody PurSuppBaseRpcParam param);



    /**
     * 回写同步结果
     *
     * @param id 供应商id，not null
     * @param outSysKey 外部系统id，not null
     * @return
     */
    @PostMapping("/sync")
    ApiResult sync(@RequestParam("id") Long id, @RequestParam("outSysKey") String outSysKey);

    @PostMapping("/sync/v2")
    ApiResult sync(@RequestBody SyncResultParam syncParam);

    @GetMapping("/findSyncDTO")
    ApiResult<PurSuppSyncDTO> findSyncDTO(@RequestParam("id") Long id);

    /**
     * 同步供应商到WMS
     *
     * @param ouId
     * @return
     */
    @GetMapping("/syncPurSuppToWms")
    ApiResult<Object> syncPurSuppToWms(@RequestParam("ouId") Long ouId);


    /**
     * 创建供应商
     */
    @PostMapping("/createPurSupp")
    ApiResult<Void> createPurSupp(@RequestBody PurSuppRpcParam param);

    @PostMapping("/findSuppTaxRpcDtoByParam")
    ApiResult<List<PurSuppTaxRpcDTO>> findSuppTaxRpcDtoByParam(@RequestBody PurSuppTaxRpcParam param);



    /**
     * 更新供应商更新状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<PurSuppSyncRpcParam> param);
}
