package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.pur.base.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2021/04/20
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "purSuppBaseDTO", description = "供应商基础信息出参对象")
public class PurSuppBaseDTO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 7299725083311757402L;
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("ERP供应商编码")
    private String erpSuppCode;

    @ApiModelProperty("供应商类型2 [UDC]PUR:SUPP_TYPE2")
    @SysCode(sys = "yst-purc", mod = "SUPP_TYPE2")
    private String suppType2;
    private String suppType2Name;

    @ApiModelProperty("供应商状态 [UDC]PUR:SUPP_STATUS")
    @SysCode(sys = "yst-purc", mod = "SUPP_STATUS")
    private String suppStatus;
    private String suppStatusName;

    @ApiModelProperty("付款条款")
    private String paymentTerm;
    private String paymentTermName;
    @ApiModelProperty("付款方式 [UDC]PUR:PAY_TYPE")
    @SysCode(sys = "yst-purc", mod = "PAY_TYPE")
    private String payMethod;
    private String payMethodName;
    @ApiModelProperty("默认发票类型 [UDC]COM:INV_TYPE")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;
    @ApiModelProperty("税率编码")
    private String taxRateNo;
    @ApiModelProperty("税率名称")
    private String taxRateDesc;
    @ApiModelProperty("税率值")
    private BigDecimal taxRateValue;
    @ApiModelProperty("纳税人类型 [UDC]ORG:PAYER_TYPE")
    @SysCode(sys = "yst-supp", mod = "PAYER_TYPE")
    private String taxPayerType;
    private String taxPayerTypeName;

    @ApiModelProperty("内部交易公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId2;
    @ApiModelProperty("内部交易公司编码")
    private String ouCode2;

    @ApiModelProperty("币种")
    private String currCode;
    @ApiModelProperty("币种名称")
    private String currName;
    @ApiModelProperty("用户ID")
    private String thirdpartyVirtualUserId;
    @ApiModelProperty("银行账户绑定流水号")
    private String thirdpartyVirtualAcc;

    @ApiModelProperty("纳税人识别号")
    private String taxPayerId;

    @ApiModelProperty("供应商归属公司")
    private List<PurSuppOuRespDTO> suppOuRespVOList;

    @ApiModelProperty("供应商简称")
    private String suppAbbr;

    @ApiModelProperty("注册地址")
    private String registerAddress;

    @ApiModelProperty("统一信用代码")
    private String certNo;

    @ApiModelProperty("法人姓名(代表)")
    private String reprName;

    @ApiModelProperty("注册资金")
    private String registerFund;

    @ApiModelProperty("经营范围")
    private String businessScope;


}
