package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购场景(PurScene)实体类
 *
 * @author tina.he
 * @since 2020-08-07 18:59:32
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "pur_scene", description = "采购场景")
public class PurSceneParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -56561862064919918L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 场景编号
     */
    @ApiModelProperty("场景编号")
    private String sceneCode;
    private List<String> sceneCodes;
    /**
     * 场景名称
     */
    @ApiModelProperty("场景名称")
    private String sceneName;
    /**
     * 场景状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty("场景状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String sceneStatus;
    /**
     * 国内国外 [UDC]PUR:PO_TYPE2
     */
    @ApiModelProperty("国内国外 [UDC]PUR:PO_TYPE2")
    private String es1;
    /**
     * 是否团内 [UDC]ORG:SUPP_TYPE2
     */
    @ApiModelProperty("是否团内 [UDC]ORG:SUPP_TYPE2")
    private String es2;
    /**
     * 是否免值 [UDC]COM:ZEROVAL_TYPE
     */
    @ApiModelProperty("是否免值 [UDC]COM:ZEROVAL_TYPE")
    private String es3;
    /**
     * 来源 [UDC]PUR:PO_GEN_TYPE
     */
    @ApiModelProperty("来源 [UDC]PUR:PO_GEN_TYPE")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5 商品类型 [UDC]PUR:PO_TYPE2")
    private String es5;
    /**
     * ES6
     */
    @ApiModelProperty("ES6  0：禁用，1：启用")
    private Integer es6;
    /**
     * ES7
     */
    @ApiModelProperty("ES7 业务类型 [UDC]PUR:BUSS_TYPE")
    private String es7;
    /**
     * ES8
     */
    @ApiModelProperty("ES8 场景类型 [UDC]PUR:SCENE_TYPE")
    private String es8;
    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private Integer es10;

    @ApiModelProperty("ES11 是否需要出入库 [UDC]PUR:STORAGE_TYPE")
    private String es11;
    /**
     * 能否手开
     */
    @ApiModelProperty("能否手开")
    private Integer ee1;
    /**
     * EE2
     */
    @ApiModelProperty("EE2")
    private Integer ee2;
    /**
     * EE3
     */
    @ApiModelProperty("EE3")
    private Integer ee3;
    /**
     * EE4
     */
    @ApiModelProperty("EE4")
    private Integer ee4;
    /**
     * EE5
     */
    @ApiModelProperty("EE5")
    private Integer ee5;
    /**
     * 订单类型 [UDC]PUR:PO_TYPE
     */
    @ApiModelProperty("订单类型 [UDC]PUR:PO_TYPE")
    private String poType;
    /**
     * 是否启用审批
     */
    @ApiModelProperty("是否启用审批")
    private Integer apprFlag;
    /**
     * 是否检查MOQ
     */
    @ApiModelProperty("是否检查MOQ")
    private Integer moqFlag;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validFrom;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validTo;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    @ApiModelProperty("关联采购场景")
    String relateSceneId;

    @ApiModelProperty("对账类型 [UDC]PUR:ACCOUNT_TYPE")
    String accountType;

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty("场景编码名称")
    private String sceneCodeName;


}
