package com.elitesland.pur.dto.supp;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * <p>
 * 功能说明:品项采购价格新增入参
 * </p>
 *
 * @Author Darren
 * @Version 1.0
 * @Content:
 * @Date 2021/02/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("品项采购价格新增入参")
public class PurPurcPriceRpcSaveDTO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -49715607599311236L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司名称:用于校验时的提示")
    private String ouName;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型（价格设置方式） UDC[yst-purc:PUR_PRICE_TYPE]")
    private String priceType;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String itemBrand;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;
    /**
     * 从数量
     */
    @ApiModelProperty("从数量")
    private Double fromQty;
    /**
     * 到数量
     */
    @ApiModelProperty("到数量")
    private Double toQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    /**
     * 不含税单价
     */
    @ApiModelProperty("不含税单价")
    private BigDecimal netPrice;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    private BigDecimal price;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 生效时间
     */
    @ApiModelProperty("生效时间")
    private LocalDateTime validFrom;
    /**
     * 失效时间
     */
    @ApiModelProperty("失效时间")
    private LocalDateTime validTo;

    @ApiModelProperty("终止日期")
    private LocalDateTime expiryDate;

    @ApiModelProperty("是否启用 1=是，0=否，默认值为1")
    private Boolean enable;

    @ApiModelProperty("收货仓库id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long recvWhId;

    @ApiModelProperty("收货仓库编码")
    private String recvWhCode;

    @ApiModelProperty("收货仓库名称")
    private String recvWhName;
}
