package com.elitesland.pur.dto.gr;

import com.elitesland.pur.base.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 采购收货单明细
 *
 * @author chaofeng.xia
 * @date 2024/4/1 19:10
 */
@Data
@ApiModel(value = "pur_gr_d", description = "采购收货单明细")
public class PurGrDRpcDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -69257486513571911L;

    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    @ApiModelProperty("关联单据编号")
    String poNo;

    /**
     * 数量
     */
    @ApiModelProperty("付款数量")
    private Double paQty;
    @ApiModelProperty("付款外币含税金额")
    BigDecimal paCurrAmt;
    /**
     * 数量
     */
    @ApiModelProperty("已付款数量")
    private Double amtQty;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private Double lineNo;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    Float purPaSrcLineNo;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;
    /**
     * 采购订单明细ID
     */
    @ApiModelProperty("采购订单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * 供应商发货单明细ID
     */
    @ApiModelProperty("供应商发货单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ssDId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品规格")
    private String itemSpec;
    private String brand;
    @ApiModelProperty("商品品牌")
    private String brandName;
    private String itemCateFullName;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;
    /**
     * 订购数量
     */
    @ApiModelProperty("采购订单订购数量")
    private BigDecimal poQty;

    @ApiModelProperty("最大允差比例")
    private BigDecimal toleranceRatio;

    @ApiModelProperty("收货允差")
    private BigDecimal recvTolerance;

    @ApiModelProperty("收货允差2")
    private BigDecimal recvTolerance2;

    @ApiModelProperty("供应商发货数量")
    private BigDecimal ssQty;

    @ApiModelProperty("采购订单可收数量")
    private BigDecimal unAcceptQty;


    /**
     * 收货数量
     */
    @ApiModelProperty("收货数量")
    private BigDecimal qty;

    /**
     * 收货状态
     */
    @ApiModelProperty("收货状态")
    @SysCode(sys = "yst-purc", mod = "RECV_STATUS")
    private String recvStatus;
    private String recvStatusName;

    @ApiModelProperty("对账数量")
    private BigDecimal checkQty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;
    /**
     * 收货数量2
     */
    @ApiModelProperty("收货数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2 - 商品主单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("发货单已拒收数量")
    private BigDecimal ssRejectedQty;

    @ApiModelProperty("采购订单已拒收数量")
    private BigDecimal poRejectedQty;

    @ApiModelProperty("此次拒收数量")
    private BigDecimal rejectQty;

    @ApiModelProperty("采购订单已收数量")
    private BigDecimal acceptQty;


    @ApiModelProperty("供应商发货单已收数量")
    private Double ssAcceptQty;

    @ApiModelProperty("订单已取消数量")
    private BigDecimal canceledQty;

    @ApiModelProperty("收货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String acceptUom;
    private String acceptUomName;

    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;
    /**
     * 发货单位
     */
    @ApiModelProperty("发货单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipmentUom;
    private String shipmentUomName;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private Double uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;
    /**
     * 交易单价 折扣后，不含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private BigDecimal transPrice;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;


    @ApiModelProperty("仓库名称")
    private String whName;


    /**
     * 仓库ID
     */
    @ApiModelProperty("销售发货仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long saleWhId;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    private String deter1;
    private String deter1Name;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    // @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    private String deter2;
    private String deter2Name;
    /**
     * 库位
     */
    @ApiModelProperty("库位")
    private String whLoc;
    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 收货批次
     */
    @ApiModelProperty("收货批次")
    private String lotNo;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 整批号
     */
    @ApiModelProperty("整批号")
    private String batchNo;
    /**
     * 过期日期
     */
    @ApiModelProperty("过期日期")
    private LocalDateTime expireDate;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 剩余效期天数
     */
    @ApiModelProperty("剩余效期天数")
    private Integer untilExpireDays;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private Double demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Integer demandAapDays;
    /**
     * 是否新鲜度合格
     */
    @ApiModelProperty("是否新鲜度合格")
    private Integer isFressValid;

    @ApiModelProperty("到货保质期比例")
    private Double actualFreshPercent;
    /**
     * 供应商发货日期
     */
    @ApiModelProperty("供应商发货日期")
    private LocalDateTime shipmentDate;
    /**
     * 异常备注
     */
    @ApiModelProperty("异常备注")
    private String exceptionDesc;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootId;

    @ApiModelProperty("外部单据公司")
    private String outerOu;

    @ApiModelProperty("外部单据类型")
    private String outerType;

    @ApiModelProperty("外部单据编号")
    private String outerNo;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerId;

    @ApiModelProperty("外部单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long outerDid;

    /**
     * 外部单据行号
     */
    @ApiModelProperty("外部单据行号")
    private Double outerLineno;

    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID - 采购订单明细")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号 - 采购订单行号")
    private Double relateDocLineno;

    @ApiModelProperty("来源单据id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocId;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("来源单据明细id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long rootDocDid;

    @ApiModelProperty("来源单据明细行号")
    private Double rootDocLineno;


    @ApiModelProperty("来源单据类别 [UDC]COM:DOC_CLS")
    private String rootDocCls;

    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private Double relateDoc2Lineno;

    @ApiModelProperty("品牌")
    private String dbrand;
    String dbrandName;

    @ApiModelProperty("基价")
    private BigDecimal basePrice;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("含税单价")
    private BigDecimal price;

    @ApiModelProperty("价格本价格")
    private BigDecimal pbPrice;

    @ApiModelProperty("价格本币种")
    private String pbCurr;

    @ApiModelProperty("价格本单位")
    private String pbUom;

    @ApiModelProperty("折扣类型")
    private String discType;

    @ApiModelProperty("折扣率")
    private Double discRatio;

    @ApiModelProperty("折扣额")
    private BigDecimal discAmt;

    @ApiModelProperty("折扣描述")
    private String discDesc;

    @ApiModelProperty("折扣后价格")
    private BigDecimal discedPrice;

    @ApiModelProperty("税码")
    private String taxCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private Double taxRate;

    @ApiModelProperty("外币含不税单价")
    private BigDecimal currNetPrice;

    @ApiModelProperty("外币含税单价")
    private BigDecimal currPrice;

    @ApiModelProperty("本币币种")
    private String homeCurr;

    @ApiModelProperty("币种")
    private String currCode;
    private String currName;

    @ApiModelProperty("汇率")
    private Double currRate;

    @ApiModelProperty("已付数量")
    Double payedQty;

    @ApiModelProperty("已付金额")
    Double payedAmt;

    @ApiModelProperty("请款人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long docEmpId;
    String docEmpName;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("临时订单详情id，背靠背业务使用")
    Long partPoDId;

    @ApiModelProperty("收货单据编号")
    String grNo;

    @ApiModelProperty("重量")
    @Column(name = "weight", columnDefinition = "float(20,8)   comment '重量'")
    Double weight;

    /**
     * 商品是否启用批次
     */
    @ApiModelProperty("商品是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("是否供应商仓库")
    private Integer isSuppWh;

    @ApiModelProperty("是否越库供应商仓库标志")
    private Integer isCrossFlagSuppWh;

    @ApiModelProperty("配额发生")
    BigDecimal partsAmtAdd;

    @ApiModelProperty("配额分配")
    BigDecimal partsAmtUse;

    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;

    @ApiModelProperty("收货地址国家")
    private String country;

    @ApiModelProperty("收货地址省")
    private String province;

    @ApiModelProperty("收货地址市")
    private String city;

    @ApiModelProperty("收货地址区县")
    private String county;

    @ApiModelProperty("地址")
    String detailAddr;

    @ApiModelProperty("采购退货登记单已签收数量")
    private BigDecimal confirmQty;
    @ApiModelProperty("退货申请数量")
    private BigDecimal rpoReturnQty;

    @ApiModelProperty("DATE1")
    private LocalDateTime date1;

    @ApiModelProperty("DATE2")
    private LocalDateTime date2;

    @ApiModelProperty("DATE3")
    private LocalDateTime date3;

    @ApiModelProperty("DATE4")
    private LocalDateTime date4;

    @ApiModelProperty("DATE5")
    private LocalDateTime date5;

    @ApiModelProperty("库存可供数量")
    private BigDecimal avalQty;

    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDate;
    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    @SysCode(sys = "yst-purc", mod = "GR_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("入库日期")
    private LocalDateTime storageDate;

    @ApiModelProperty("是否免税")
    private Boolean taxFreeFlag;

    @ApiModelProperty("待收货数量")
    private BigDecimal  leaveReceivedQty;
    @ApiModelProperty("是否为复制数据行")
    private Boolean isCopy;

    @ApiModelProperty("商品库存状态 [UDC:inv]STK_ITM_STATUS")
    @SysCode(sys = "yst-inv", mod = "STK_ITM_STATUS")
    private String stkItmStatus;
    private String stkItmStatusName;

    @ApiModelProperty("对账状态 [UDC:yst-purc]ACCOUNT_STATUS")
    @SysCode(sys = "yst-purc", mod = "ACCOUNT_STATUS")
    private String accountStatus;
    private String accountStatusName;

    @ApiModelProperty("开票数量")
    private BigDecimal invoiceQty;
}
