package com.elitesland.pur.provider;

import com.elitesland.pur.Application;
import com.elitesland.pur.dto.SrmUserRelateRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2025/10/17 11:25
 */
@Validated
@FeignClient(name = Application.NAME, path = Application.PATH + SrmUserRelateProvider.PATH)
public interface SrmUserRelateProvider {

    String PATH = "/srmUserRelate";

    @PostMapping("findBySuppCodes")
    List<SrmUserRelateRpcDTO> findBySuppCodes(@RequestBody  List<String> suppCodes);
}
