package com.elitesland.pur.dto.gr;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;


/**
 * <p>
 * 采购收货单(PurGr)实体类
 * </p>
 *
 * @author zhao_qiao_gong
 * @since 2020-08-05 17:04:51
 */
@Data
@ApiModel(value = "pur_gr", description = "采购收货单")
@EqualsAndHashCode(callSuper = true)
public class PurGrRpcParamVO extends AbstractExportQueryParam {
    private static final long serialVersionUID = 4319877624731174270L;

    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;
    /**
     * 公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private List<String> docNos;

    /**
     * 单据状态 [UDC]PUR:GR_STATUS
     */
    @ApiModelProperty("单据状态 [UDC]PUR:GR_STATUS")
    private List<String> docStatuslist;
    /**
     * 收货日期
     */
    @ApiModelProperty("收货日期")
    private LocalDateTime recvDateS;
    private LocalDateTime recvDateE;

    /**
     * 供应商ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> suppIds;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;
    /**
     * 收货人员工ID
     */
    @ApiModelProperty("收货人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> recvEmpIds;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> relateDocIds;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String relateDocNo;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("商品ids")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty("商品品牌s")
    private List<String> brands;

    @ApiModelProperty("收货批次")
    private String lotNo;

    @ApiModelProperty("采购场景批量查询")
    private List<String> sceneTypeCodeList;

    @ApiModelProperty("采购场景ID批量查询")
    private List<Long> sceneTypeIds;

    @ApiModelProperty("来源单据编号")
    private String rootDocNo;


    @ApiModelProperty("商品编码")
    private String itemCode;


    @ApiModelProperty("项目编码集合")
    private List<String> projectCodes;

    @ApiModelProperty("记账日期")
    private LocalDateTime finDateS;
    private LocalDateTime finDateE;

    @ApiModelProperty("推送WMS状态")
    private List<String> wmsStatus;

    @ApiModelProperty("推送WMS时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTimeBegin;

    @ApiModelProperty("推送WMS时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsTimeEnd;

    @ApiModelProperty("接收WMS回传状态")
    private List<String> wmsFeedbackStatus;

    @ApiModelProperty("撤回WMS时间开始")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsCancelTimeBegin;

    @ApiModelProperty("撤回WMS时间结束")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime wmsCancelTimeEnd;
}
