package com.elitesland.pur.dto.supp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/05/23
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "purSuppQualifyRpcDTO", description = "供应商证照出参对象")
public class PurSuppQualifyRpcDTO implements Serializable {
    private static final long serialVersionUID = 7707613568494844090L;

    @ApiModelProperty("地址信息ID")
    private Long id;

    @ApiModelProperty(value = "地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    @ApiModelProperty("证照(资质文件)编号")
    String qualifyNo;

    @ApiModelProperty("证照(资质)类型 :[UDC]ORG:ADDR_QUALIFY_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_QUALIFY_TYPE")
    String qualifyType;
    @ApiModelProperty("资质类型名称")
    String qualifyTypeName;

    @ApiModelProperty("资质证照状态 [UDC]COM:STATUS_ACTIVEORNO")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    String qualifyStatus;
    @ApiModelProperty("资质证照状态")
    String qualifyStatusName;

    @ApiModelProperty("生效时间")
    LocalDateTime validFrom;

    @ApiModelProperty("失效时间")
    LocalDateTime validTo;

    @ApiModelProperty("资质文件名称")
    String qualifyFileName;

    @ApiModelProperty("资质文件编号(上传后系统生成的编号)")
    String qualifyFileCode;

    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("主表业务类型")
    String masDocCls;

}
