package com.elitesland.pur.dto.supp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 04月 15日 17:36
 * @version: 1.0
 */
@Data
@ApiModel(value = "PurSuppTaxRpcDTO", description = "供应商商品税率")
public class PurSuppTaxRpcDTO implements Serializable {

    @ApiModelProperty(value = "供应商id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;


}
