package com.elitesland.pur.dto.rns;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "退货申请单")
public class PurRnsRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("地址号")
    Long addrNo;

    @ApiModelProperty("承运商")
    private String carrier;

    @ApiModelProperty("配送方式")
    private String deliverMethod;

    @ApiModelProperty("物流单号")
    private String logisDocNo;

    @ApiModelProperty("发货仓库")
    private Long fromWhId;

    @ApiModelProperty("收货供应商")
    private Long suppId;

    @ApiModelProperty("收货供应商")
    private String suppCode;

    @ApiModelProperty("收货供应商")
    private String suppName;

    @ApiModelProperty("状态")
    private String docStatus;


    @ApiModelProperty(value = "退货类型[UDC]INV:RETURN_TYPE")
    private String returnType;

    @ApiModelProperty(value = "退货原因[UDC]INV:RETURN_REASON")
    private String returnReason;

    @ApiModelProperty(value = "退款方式[UDC]INV:REFUND_METHOD")
    private String refundMethod;

    @ApiModelProperty(value = "责任方[UDC]INV:LIABLE_PARTY")
    private String liableParty;

    @ApiModelProperty(value = "追责状态[UDC]INV:LIABILITY_STATUS")
    private String liabilityStatus;

    private List<PurRnsDRpcDTO> rnsDRpcDTOS;
}