package com.elitesland.pur.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lvqf
 * @Date 2021/6/17
 * @Description
 */
@Data
public class SrmUserRelateRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -1521906496499335214L;

    @ApiModelProperty("供应商编码")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;
    @ApiModelProperty("用户名")
    private String username;
    @ApiModelProperty("姓名")
    private String firstName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("用户ID")
    private Long sysUserId;
    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty("备注")
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("供应商id")
    private Long suppId;

    @ApiModelProperty("供应商公司编码列表")
    private List<String> ouCodeList;

}
