package com.elitesland.pur.dto.gr;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "采购收货单")
public class PurGrSimpleRpcDTO implements Serializable {

    private static final long serialVersionUID = -9066194839868175002L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("单号")
    private String docNo;

    @ApiModelProperty("创建日期")
    private LocalDateTime createTime;

    @ApiModelProperty("收货仓库")
    private Long whId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("发货供应商")
    private Long suppId;

    @ApiModelProperty("自动收货天数")
    private Integer autoRecvDays;


}