package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * 门店信息 RPC VO
 *
 * @author system
 * @date 2025-10-17
 */
@Data
@ApiModel(description = "门店信息")
@NoArgsConstructor
@AllArgsConstructor
public class StoreRpcVO implements Serializable {

    private static final long serialVersionUID = 2025101700000004L;

    @ApiModelProperty(value = "SAP编码")
    private String sapId;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty(value = "门店简称")
    private String storeName;

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    @ApiModelProperty(value = "门店详细地址")
    private String storeAddress;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "南北战区")
    private String warArea;

    @ApiModelProperty(value = "大区经理")
    private String regionManager;

    @ApiModelProperty(value = "省经理")
    private String provinceManager;

    @ApiModelProperty(value = "区域经理")
    private String areaManager;

    @ApiModelProperty(value = "开业日期")
    private LocalDate openingDate;

    @ApiModelProperty(value = "店铺营业额等级")
    private String storeTurnoverLevel;

    @ApiModelProperty(value = "是否属于代理区域：是、否")
    private String isAgentArea;

    @ApiModelProperty(value = "代理商姓名")
    private String agentName;

    @ApiModelProperty(value = "代理返点比例")
    private String agentRate;

    @ApiModelProperty(value = "代理级别")
    private String agentLevel;

    @ApiModelProperty(value = "是否为学校店铺：是、否")
    private String isSchoolStore;

    @ApiModelProperty(value = "是否补贴：是、否")
    private String subsidyRequired;

    @ApiModelProperty(value = "补贴金额（万）")
    private String subsidyAmount;

    @ApiModelProperty(value = "是否提价")
    private String priceIncrease;

    @ApiModelProperty(value = "收货地址省")
    private String deliveryAddressProvince;

    @ApiModelProperty(value = "收货地址市")
    private String deliveryAddressCity;

    @ApiModelProperty(value = "收货地址区")
    private String deliveryAddressDistrict;

    @ApiModelProperty(value = "收货地址")
    private String deliveryAddress;

    @ApiModelProperty(value = "收货人")
    private String consignee;

    @ApiModelProperty(value = "收货人联系方式")
    private String consigneeContact;

    @ApiModelProperty(value = "收货人备用联系方式")
    private String consigneePhoneReserve;

    @ApiModelProperty(value = "发货仓库")
    private String warehouse;

    @ApiModelProperty(value = "报货负责人")
    private String merchandiser;

    @ApiModelProperty(value = "银联商户号")
    private String unionpayMerchantNum;

    @ApiModelProperty(value = "银联终端号")
    private String unionpayTerminalNumber;

}

