package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.store.Application;
import com.tll.store.rpc.dto.*;
import com.tll.store.rpc.param.query.LegalPersonInfoQueryDTO;
import com.tll.store.rpc.param.query.LegalPersonInfoRepDTO;
import com.tll.store.rpc.vo.LegalPersonInfoRepVO;
import com.tll.store.rpc.vo.StoreInfoRpcVO;
import com.tll.store.rpc.vo.UserStoreRankingRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * @Author: Unicorn
 * @Description: 门店管理RPC接口
 * @Date: 2025/1/13 14:19
 * @Version: 1.0
 */
@FeignClient(name = Application.NAME, path = StoreClientRpcService.URI)
@Validated
public interface StoreClientRpcService {

    String URI = Application.URI_PREFIX + "/storeClient";

    /**
     * 通过手机号查询门店法人信息
     * @param queryDTO
     * @return
     */
    @GetMapping(value = "/findByPhone")
    ApiResult<LegalPersonInfoRepDTO> findByPhone(@RequestBody LegalPersonInfoQueryDTO queryDTO);


    @PostMapping(value = "/queryLegalPersonInfo")
    @ApiOperation(value = "查询加盟商法人信息")
    ApiResult<LegalPersonInfoRepVO> queryLegalPersonInfo(@RequestBody LegalPersonInfoRpcDTO legalPersonInfoRpcDTO);

    /**
     * 根据门店编码批量查询门店信息
     * @param queryDTO
     * @return
     */
    @PostMapping(value = "/findByStoreCodes")
    @ApiOperation(value = "根据门店编码批量查询门店信息")
    ApiResult<List<StoreInfoRpcVO>> findByStoreCodes(@RequestBody StoreCodeRpcDTO queryDTO);

    /**
     * 更新门店信息
     * @param saveDto
     * @return
     */
    @PostMapping(value = "/createByContract")
    @ApiOperation(value = "更新门店信息")
    ApiResult<String> createByContract(@RequestBody CreateByContractRPCDto saveDto);


    @ApiOperation(value = "更新门店房租金额")
    @PostMapping(value = "/updateStoreRent")
    ApiResult<String> updateStoreRent(@RequestBody StoreRentRpcDTO storeRentRpcDTO);

    @ApiOperation(value = "查询人员门店排行榜")
    @PostMapping(value = "/queryUserStoreRanking")
    ApiResult<PagingVO<UserStoreRankingRpcVO>> queryUserStoreRanking(@RequestBody UserStoreRankingRpcDTO dto);
}
