package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhaoshuai
 * @date 2025/8/27
 */
@Data
@ApiModel("巡检门店信息查询DTO")
public class InspectStoreQueryRpcDTO {

    @ApiModelProperty(value = "查询开始日期（yyyy-MM-dd）", required = true)
    private String startDate;

    @ApiModelProperty(value = "查询结束日期（yyyy-MM-dd）", required = true)
    private String endDate;

    @ApiModelProperty(value = "查询类型 0督导、1区域经理、2省经理、3战区", required = true)
    private Integer userType;

    @ApiModelProperty(value = "用户ids", required = false)
    private List<String> userIds;
}
