package com.tll.store.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Set;

/**
 * @author: daidemin
 * Date: 2024/11/12 14:01
 */
@Data
@ApiModel("门店列表查询条件")
public class StoreInfoListQueryRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty(value = "登记人id")
    private String registrantId;

    @ApiModelProperty("门店编号/门店名称/法人姓名/法人手机号")
    private String storeDetail;

    @ApiModelProperty("省ID列表")
    private List<String> province;

    @ApiModelProperty("市ID列表")
    private List<String> city;

    @ApiModelProperty("区ID列表")
    private List<String> district;

    @ApiModelProperty("运营状态： 0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约 ")
    private Integer operationStatus;

    @ApiModelProperty("门店类型： 1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "经度")
    private double longitude;

    @ApiModelProperty(value = "纬度")
    private double latitude;

    @ApiModelProperty("法人")
    private String legalPerson;

    @ApiModelProperty("法人电话")
    private String legalPersonPhone;

    @ApiModelProperty("员工姓名")
    private String staffName;

    @ApiModelProperty(value = "特殊处理(控制返回数据是否排序)")
    private Boolean special = false;

    @ApiModelProperty(value = "权限开关处理")
    private Boolean permission = false;

    @ApiModelProperty(value = "门店法人组合查询(输入门店法人姓名或手机号查询)")
    private String storeLegalPerson;

    @ApiModelProperty(value = "门店信息组合信息查询(门店编码或门店名称查询)")
    private String storeInfo;

    @ApiModelProperty(value = "门店编码列表")
    private List<String> storeCodes;

    //门店：按门店编号，门店名称，法人名称，法人手机号，查询范围为对应门店的巡检报告
    @ApiModelProperty("门店信息搜索条件")
    private String storeCondition;

    //门店负责人：支持输入员工姓名查询，查询范围为员工作为门店的负责人（督导，区域经理，省经理，大区经理）的门店的巡检报告
    @ApiModelProperty("门店负责人搜索条件")
    private String personCondition;

    @ApiModelProperty("是否过滤解约的门店(true过滤 false不过滤)")
    private Boolean filterTermination = false;

    @ApiModelProperty("门店负责人：指输入员工姓名查询门店管理人员管理的门店，范围包括：督导-区域经理-省经理-战区总（如建多个角色，按权限高的角色的查询）")
    private String storeManager;


    @ApiModelProperty(value = "不查的门店编码列表")
    private Set<String> notInStoreCodes;

    @ApiModelProperty("只查storeCode")
    private Boolean onlyStoreCode = false;

    @ApiModelProperty(value = "权限外额外要查询到门店编码列表")
    private List<String> extraStoreCodes;
}
