package com.tll.store.rpc.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * @author: daidemin
 * Date: 2024/11/12 18:24
 */
@Data
@ApiModel("门店简单信息")
public class PgcStoreRpcVO implements Serializable {

    @ApiModelProperty(value = "门店ID")
    private String storeName;

    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;

    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;

    @ApiModelProperty(value = "区域经理")
    private String areaManager;

    @ApiModelProperty(value = "门店地址")
    private String storeAddress;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private Integer operationStatus;

    @ApiModelProperty(value = "运营状态：0：签约、1：营业中、2：短期闭店、3：空合同、4：到期解约、5：长期闭店、7：待装修、8：强制解约、9：其它解约")
    private String operationStatusDesc;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;


    @ApiModelProperty(value = "登记日期")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDate registrationDate;

    @ApiModelProperty(value = "登记人")
    private String registrant;


    @ApiModelProperty(value = "U8C客商编码")
    private String u8cCustomerCode;


    @ApiModelProperty(value = "直营店长")
    private String storeManager;


    @ApiModelProperty(value = "地图标注")
    private String mapAnnotation;

    @ApiModelProperty(value = "直营店经理")
    private String storeDirector;


    @ApiModelProperty(value = "直营店主管")
    private String storeSupervisor;

    @ApiModelProperty(value = "收货人")
    private String consignee;

    @ApiModelProperty(value = "收货人联系方式")
    private String consigneeContact;

    @ApiModelProperty(value = "是否有无收银机   0：否   1：是")
    private String hasCashierMachine;

    @ApiModelProperty(value = "收货地址省")
    private String deliveryAddressProvince;

    @ApiModelProperty(value = "收货地址市")
    private String deliveryAddressCity;

    @ApiModelProperty(value = "收货地址区")
    private String deliveryAddressDistrict;

    @ApiModelProperty(value = "收货地址")
    private String deliveryAddress;


    @ApiModelProperty(value = "是否为学校店铺   0：否   1：是")
    private Boolean schoolStore;

    @ApiModelProperty(value = "开业日期")

    private LocalDate openingDate;

    @ApiModelProperty(value = "线上推广费已收取")
    private String onlinePromotionFeeReceived;

    @ApiModelProperty(value = "收银机ID")
    private String cashRegisterId;

    @ApiModelProperty(value = "商机编号")
    private String businessOpportunityId;

    @ApiModelProperty(value = "老店复签")
    private Boolean oldStoreRenewal;

    @ApiModelProperty(value = "物流公司名称")
    private String logisticsCompanyName;

    @ApiModelProperty(value = "门店预售推广费是否已收取   0：否   1：是")
    private String storePresalePromotionFeeReceived;


    private LocalDate terminationDate;

    @ApiModelProperty(value = "门店套餐")
    private String storePackage;

    @ApiModelProperty(value = "所属城市等级")
    private String cityLevel;

    @ApiModelProperty(value = "所属行政区划")
    private String administrativeDivision;

    @ApiModelProperty(value = "所属商圈")
    private String businessDistrict;

    @ApiModelProperty(value = "商圈等级")
    private String businessDistrictLevel;

    @ApiModelProperty(value = "店铺营业额等级")
    private String storeTurnoverLevel;

    @ApiModelProperty(value = "发货仓库")
    private String warehouse;

    @ApiModelProperty(value = "是否提价 ")
    private String priceIncrease;


    @ApiModelProperty(value = "冷链发货仓")
    private String coldChainWarehouse;

    @ApiModelProperty(value = "需要封口机贴   0：否   1：是")
    private Boolean sealingMachineRequired;

    @ApiModelProperty(value = "需要二门头横幅   0：否   1：是")
    private Boolean bannerRequired;

    @ApiModelProperty(value = "需要大展架展画   0：否   1：是")
    private Boolean displayRackRequired;

    @ApiModelProperty(value = "门头类型")
    private String doorheadType;

    @ApiModelProperty(value = "门头尺寸（m）")
    private String storeSize;

    @ApiModelProperty(value = "地毯尺寸")
    private String carpetSize;


    @ApiModelProperty(value = "大区经理")
    private String regionManager;

    @ApiModelProperty(value = "省经理")
    private String provinceManager;


    @ApiModelProperty(value = "督导")
    private String supervisor;

    @ApiModelProperty(value = "门店电话")
    private String storePhone;


    @ApiModelProperty(value = "报货负责人")
    private String merchandiser;


    private List<StoreTagRpcVO> storeTagList;

    @ApiModelProperty(value = "信发标签")
    private String storeLabel;


}
