package com.tll.store.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 0督导、1区域经理、2省经理
 */
@Getter
@AllArgsConstructor
public enum UserPosionTypeEnum {

    SUPERVISOR(0, "督导"),
    AREA_MANAGER(1, "区域经理"),
    PROVINCE_MANAGER(2, "省经理"),
    WAR_ARAE(3, "战区");

    private final Integer code;
    private final String desc;

    /**
     * 根据编码获取描述
     * @param code 编码
     * @return 描述信息
     */
    public static String getDescByCode(Integer code) {
        for (UserPosionTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type.getDesc();
            }
        }
        return null;
    }
}
