package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 违约通知单记录关联罚款项实体.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */
@ApiModel(description = "违约通知单记录关联罚款项保存实体")
@Data
public class ReminderFineItemInsertDTO implements Serializable {

    /**
     * 罚款单编号
     */
    @ApiModelProperty(value = "罚款单编号", required = true)
    @NotBlank(message = "罚款单编号不能为空")
    private String fineTicketId;

    /**
     * 违约通知单编号
     */
    @ApiModelProperty(value = "违约通知单编号", required = true)
    @NotBlank(message = "违约通知单编号不能为空")
    private String reminderId;
    /**
     * 违规惩罚事项
     */
    @ApiModelProperty(value = "违规惩罚事项", required = true)
    @NotBlank(message = "违规惩罚事项不能为空")
    private String fineItem;
    /**
     * 罚款类型
     */
    @ApiModelProperty(value = "罚款类型", required = true)
    @NotBlank(message = "罚款类型不能为空")
    private String fineType;
    /**
     * 罚款金额
     */
    @ApiModelProperty(value = "罚款金额", required = true)
    @NotBlank(message = "罚款金额不能为空")
    private BigDecimal penaltyAmount;


}
