package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author by wuyunfeng
 * @Classname StoreEmployeeVO
 * @Date 2024/11/18 16:41
 */
@Data
@ApiModel(description = "门店员工列表")
public class StoreEmployeeRpcVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "员工id")
    private String userId;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "角色id 1:门店负责人(加盟商) 2:店长  3:店员  4:代理商")
    private String roleId;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "联系方式")
    private String account;

    @ApiModelProperty(value = "权限id")
    private String menuId;

    @ApiModelProperty(value = "是否代理商：是、否")
    private String isAgent;

    @ApiModelProperty(value = "头像")
    private String userPhoto;

    @ApiModelProperty(value = "姓名")
    private String userName;

    @ApiModelProperty(value = "身份证号")
    private String idcard;

    @ApiModelProperty(value = "性别 0:男 1:女")
    private Integer gender;

    @ApiModelProperty(value = "民族")
    private String nation;

    @ApiModelProperty(value = "出生日期")
    private String birthday;

    @ApiModelProperty(value = "居住地址")
    private String address;

    @ApiModelProperty(value = "身份证照片 正面")
    private String identityCardImage;

    @ApiModelProperty(value = "身份证照片 反面")
    private String identityCardImageBack;

    @ApiModelProperty(value = "身份证发证日期")
    private LocalDate identityDate;

    @ApiModelProperty(value = "身份证结束日期")
    private LocalDate identityExpireDate;

    @ApiModelProperty(value = "健康证照片")
    private String healthImage;

    @ApiModelProperty(value = "健康证发证日期")
    private LocalDate healthDate;

    @ApiModelProperty(value = "健康证结束日期")
    private LocalDate healthExpireDate;

    @ApiModelProperty(value = "账号状态 0:启用 1:禁用 2:删除")
    private Integer status;


}
