package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author: daidemin
 * Date: 2024/11/12 19:36
 */
@Data
@ApiModel(value = "门店基本信息")
@NoArgsConstructor
@AllArgsConstructor
public class StoreBasicInfoRpcVO implements Serializable {

    @ApiModelProperty(value = "法人姓名")
    private String legalPerson;
    @ApiModelProperty(value = "法人电话")
    private String legalPersonPhone;
    @ApiModelProperty(value = "运营状态")
    private Integer operationStatus;
    @ApiModelProperty(value = "运营状态")
    private String operationStatusStr;
    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;
    @ApiModelProperty(value = "直营店长")
    private String storeManager;
    @ApiModelProperty(value = "直营店经理")
    private String storeDirector;
    @ApiModelProperty(value = "直营店主管")
    private String storeSupervisor;
    @ApiModelProperty(value = "是否有无收银机：是、否")
    private String hasCashierMachine;
    @ApiModelProperty(value = "是否为学校店铺：是、否")
    private String isSchoolStore;
    @ApiModelProperty(value = "开业日期")
    private LocalDate openingDate;
    @ApiModelProperty(value = "所属城市等级 : 一线、新一线、二线、三线、四线、无线")
    private String cityLevel;
    @ApiModelProperty(value = "所属行政区划 : 市区、县城、乡镇")
    private String administrativeDivision;
    @ApiModelProperty(value = "所属商圈 : 商业街店、商场店（内部）、商场店（外部）、小吃街店、普通沿街商铺店、社区店、学校店")
    private String businessDistrict;
    @ApiModelProperty(value = "商圈等级 : S类商圈、A类商圈、B类商圈、C类商圈、5A风景区")
    private String businessDistrictLevel;
    @ApiModelProperty(value = "店铺营业额等级   : A/B/C/D/E ")
    private String storeTurnoverLevel;
    @ApiModelProperty(value = "店铺盈亏等级    : A/B/C/D/E")
    private String storeProfitLossLevel;

}
