package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.store.Application;
import com.tll.store.rpc.dto.FineStoreInspectReportQueryRpcDTO;
import com.tll.store.rpc.vo.InspectReportListRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 违约单服务接口.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */
@FeignClient(name = Application.NAME, path = ReminderFineRpcService.URI)
public interface ReminderFineRpcService {
    String URI = Application.URI_PREFIX + "/reminderFine";

    @PostMapping(value = "/fineStoreInspectReports")
    @ApiOperation(value = "分页查询罚款门店90天巡检报告")
    ApiResult<PagingVO<InspectReportListRpcVO>> fineStoreInspectReports(@RequestBody @Valid FineStoreInspectReportQueryRpcDTO queryDTO);
}
