package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.vo.RefundRecordRpcVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 退款记录服务
 *
 * @author nian_yh
 * @date 2025/11/17
 */
@FeignClient(name = Application.NAME, path = ReminderFineItemRpcService.URI)
@Validated
public interface RefundRecordRpcService {
    /**
     * URI
     */
    String URI = Application.URI_PREFIX + "/recordClient";

    /**
     * 更新状态
     *
     * @return {@link ApiResult }<{@link ? }>
     */
    @PostMapping("/update")
    @ApiOperation("更新回调状态")
    ApiResult<?> update(@RequestBody RefundRecordRpcVo vo);
}
