package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 违约金返还通知单记录保存实体.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */

@ApiModel(description = "违约金返还通知单记录保存实体")
@Data
public class ReminderCashbackInsertDTO implements Serializable {


    /**
     * 违约金返还通知单编号
     */
    @ApiModelProperty(value = "违约金返还通知单编号", required = true)
    @NotBlank(message = "违约金返还通知单编号不能为空")
    private String cashbackId;
    /**
     * 流程id
     */
    @ApiModelProperty(value = "流程id", required = true)
    @NotBlank(message = "流程id不能为空")
    private String affairId;

    private String oaFormId;

    private String businessNo;

    /**
     * 罚款单编号
     */
    @ApiModelProperty(value = "罚款单编号", required = true)
    @NotBlank(message = "罚款单编号不能为空")
    private String fineTicketId;

    /**
     * 3个月到期可返还金额
     */
    @ApiModelProperty(value = "3个月到期可返还金额")
    private BigDecimal threeMonthAmount;
    /**
     * 一年到期可返还金额
     */
    @ApiModelProperty(value = "一年到期可返还金额")
    private BigDecimal oneYearAmount;

}
