package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 违约金变更保存实体.
 *
 * @author taojjun
 * @date 2024-11-07 16:19:39
 */

@ApiModel(description = "违约金变更保存实体")
@Data
public class ReminderFineChangeAmountInserDTO implements Serializable {

    /**
     * 罚款单编号
     */
    @ApiModelProperty(value = "罚款单编号", required = true)
    @NotBlank(message = "罚款单编号不能为空")
    private String fineTicketId;
    /**
     * 罚款金额
     */
    @ApiModelProperty(value = "变更后罚款金额", required = true)
    @NotNull(message = "变更后罚款金额不能为空")
    private BigDecimal penaltyAmount;
}
