package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.param.save.ReminderFineChangeAmountInserDTO;
import com.tll.store.rpc.param.save.ReminderFineInsertDTO;
import com.tll.store.rpc.param.save.ReminderFineItemInsertDTO;
import com.tll.store.rpc.param.save.ReminderFineItemPaymentInsertDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 违约单服务接口.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */
@FeignClient(name = Application.NAME, path = ReminderFineItemRpcService.URI)
@Validated
public interface ReminderFineItemRpcService {
    String URI = Application.URI_PREFIX + "/reminderFineItem";

    /**
     * 新增数据
     *
     * @param insertDTO 新增数据信息
     * @return 数据ID
     */
    @PostMapping(value = "/afterPayment")
    ApiResult<Long> afterPayment(@RequestBody @Valid ReminderFineItemPaymentInsertDTO insertDTO);
    @PostMapping(value = "/changePenaltyAmount")
    ApiResult<Long> changePenaltyAmount(@RequestBody @Valid ReminderFineChangeAmountInserDTO inserDTO);

}
