package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.dto.*;
import com.tll.store.rpc.vo.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author: daidemin
 * Date: 2024/12/24 14:46
 */
@FeignClient(name = Application.NAME, path = TaskCenterRpcService.URI)
@Validated
public interface TaskCenterRpcService {
    String URI = Application.URI_PREFIX + "/api/taskClient";


    @PostMapping(value = "/getStoreEmployeeList")
    @ApiOperation(value = "获取门店员工列表")
    ApiResult<List<StoreEmployeeListRpcVO>> queryStoreEmployeeList(@RequestBody @Validated StoreEmployeeRpcDTO storeEmployeeRpcDTO);


    @PostMapping(value = "/getRegionalManagerListById")
    @ApiOperation(value = "根据id获取区域经理门店信息列表")
    ApiResult<EmployeeBasicInfoRpcVO> getRegionalManagerListById(@RequestBody EmployeeIdRpcDTO employeeIdRpcDTO);


    @PostMapping(value = "/getRegionalManagerListByStoreCode")
    @ApiOperation(value = "根据门店编码获取区域经理信息列表")
    ApiResult<EmployeeBasicInfoRpcVO> getRegionalManagerListByStoreCode(@RequestBody StoreCodeRpcDTO storeCodeRpcDTO);


    @PostMapping(value = "/getStoreCodeListByStatus")
    @ApiOperation(value = "根据门店状态获取门店编码集合")
    ApiResult<StoreCodeListRpcVO> getStoreCodeListByStatus(@RequestBody StoreStatusQueryRpcDTO storeStatusQueryDTO);
    
    
    @PostMapping(value = "/getSonyStore")
    @ApiOperation(value = "根据人员查询直营店数据")
    ApiResult<SonyStoreRpcVO> getSonyStore(@RequestBody SonyStoreRpcDTO sonyStoreDTO);


    @PostMapping(value = "/getSonyStoreFranchise")
    @ApiOperation(value = "查询门店信息加盟店直营店融合")
    ApiResult<SonyStoreRpcVO> getSonyStoreFranchise(@RequestBody SonyStoreFranchiseRpcDTO sonyStoreFranchiseDTO);

    @PostMapping(value = "/getStoreCodes")
    @ApiOperation(value = "获取门店编码集合")
    ApiResult<StoreCodeRpcVO> getStoreCodes(@RequestBody FilterStoreParamRpcDTO filterStoreParamRpcDTO);
}
