package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 门店定位修改请求实体类
 *
 * @author Jxinx
 * @since 2025-09-27
 */
@Data
@ApiModel(value = "门店定位修改请求实体类")
public class StoreLocationUpdateRpcDTO implements Serializable {

    private static final long serialVersionUID = -7087700779473572929L;

    @ApiModelProperty(value = "门店编码")
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

    /**
     * 门店经度
     */
    @ApiModelProperty(value = "门店经度")
    @NotNull(message = "门店经度不能为空")
    private Double longitude;

    /**
     * 门店纬度
     */
    @ApiModelProperty(value = "门店纬度")
    @NotNull(message = "门店纬度不能为空")
    private Double latitude;

    /**
     * 定位地址
     */
    @ApiModelProperty(value = "定位地址")
    private String address;

}
