package com.tll.store.rpc.dto;

import com.elitescloud.cloudt.common.base.param.QueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Data
public class PagePgcStoreRpcDTO extends QueryParam {


    @ApiModelProperty("门店名称或者code")
    private String storeCodeOrStoreName;


    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("门店code集合")
    private Set<String> includeStoreCodeSet;

    @ApiModelProperty("法人")
    private String legalPerson;

    /**
     * 法人电话
     */
    @ApiModelProperty("法人电话")
    private String legalPersonPhone;


    @ApiModelProperty("门店类型")
    private Integer storeType;


    @ApiModelProperty("省ID列表")
    private Set<String> provinceSet;

    @ApiModelProperty("市ID列表")
    private Set<String> citySet;

    @ApiModelProperty("区ID列表")
    private Set<String> districtSet;

    @ApiModelProperty("门店信发标签")
    private List<String> storeLabelList;

    @ApiModelProperty("是否包含提价区域")
    private Boolean raisePriceArea;
    @ApiModelProperty("区域经理")
    private String areaManager;

    @ApiModelProperty("门店操作状态")
    private Set<Integer> operateStatusList = new HashSet<>();

}
