package com.tll.store.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * Author: daidemin
 * Date: 2024/10/17 11:05
 */
@ApiModel(value = "门店员工列表查询参数")
@Data
public class StoreEmployeeRpcDTO extends AbstractExportQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "门店编号")
    @NotEmpty(message = "门店编号不能为空")
    private List<String> storeCode;

    @ApiModelProperty(value = "角色id 1:门店负责人(加盟商) 2:店长  3:店员  4:代理商")
    @Size(min = 1, message = "角色id不能为空")
    @NotEmpty(message = "角色id不能为空")
    private List<String> roleIdList;

}
