package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 列表/详情展示VO
 *
 * @author nian_yh
 * @date 2025/11/10
 */
@Data
@ApiModel("RefundRecordVO - 违约金返还VO")
public class RefundRecordRpcVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /* ========================== 基础信息 ========================== */
    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "返还单号(申请单号)")
    private String refundNo;

    /* ========================== 罚款单相关字段 ========================== */
    @ApiModelProperty("罚款单号")
    private String fineNo;

    @ApiModelProperty(value = "罚款金额")
    private BigDecimal fineAmount;

    @ApiModelProperty(value = "罚款支付时间")
    private LocalDateTime finePaymentTime;

    @ApiModelProperty("罚款类型")
    private Integer fineType;

    @ApiModelProperty("罚款类型描述")
    private String fineTypeName;

    @ApiModelProperty("罚款来源（如：督察部/市场部）")
    private String fineSource;

    @ApiModelProperty("罚款项名称/费用项")
    private String expenseName;

    @ApiModelProperty("罚款日期")
    private String fineDate;

    @ApiModelProperty("罚款创建日期")
    private LocalDateTime fineCreateDate;

    /* ========================== 门店信息 ========================== */
    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店简称")
    private String storeName;

    @ApiModelProperty(value = "门店全称")
    private String storeFullName;

    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;

    @ApiModelProperty(value = "省市区")
    private String provinceCityArea;

    @ApiModelProperty(value = "大区经理")
    private String regionManager;

    @ApiModelProperty(value = "区域经理")
    private String provinceManager;

    @ApiModelProperty(value = "督导")
    private String areaManager;

    @ApiModelProperty(value = "直营店长")
    private String storeManager;

    @ApiModelProperty(value = "直营店经理")
    private String storeDirector;

    @ApiModelProperty(value = "直营店主管")
    private String storeSupervisor;

    @ApiModelProperty(value = "sap编码")
    private String sapId;

    @ApiModelProperty(value = "门店类型：1：加盟店  0：直营店")
    private Integer storeType;

    /* ========================== 返还单数据信息 ========================== */
    @ApiModelProperty("返还类型")
    private String refundType;

    @ApiModelProperty("返还类型:90-90天返还，365-一年返还")
    private String refundTypeName;

    @ApiModelProperty("返还状态")
    private Integer refundStatus;

    @ApiModelProperty("返还状态：0 - 待返，1 - 返还中，2 - 返还完成，3 - 返还取消，4 - 无需返还，5 - 返还失败，-1 - 未知")
    private String refundStatusName;

    @ApiModelProperty("本次返还金额")
    private BigDecimal refundAmount;

    @ApiModelProperty(value = "剩余待返金额")
    private BigDecimal remainingAmount;

    @ApiModelProperty(value = "返还支付时间")
    private LocalDateTime paymentTime;

    @ApiModelProperty(value = "发起时间（返还单发起时间）")
    private LocalDateTime initiateTime;

    @ApiModelProperty("返还说明（状态文案）")
    private String refundExplain;

    @ApiModelProperty("父单/关联单号（用于 90 天 <-> 365 天 互相跳转，对齐 DO 的 parent_refund_no）")
    private String parentRefundNo;

    @ApiModelProperty("发起时巡检次数快照")
    private Integer inspectionCountSnapshot;

    /* ========================== 发起信息 ========================== */
    @ApiModelProperty(value = "返还发起人")
    private String initiator;

    @ApiModelProperty(value = "发起说明")
    private String initiateRemark;

    @ApiModelProperty("发起类型")
    private String initiatorType;

    @ApiModelProperty("发起类型名称")
    private String initiatorTypeName;

    /* ========================== 审批信息 ========================== */
    @ApiModelProperty("审批单号（系统域）")
    private String approvalNo;

    @ApiModelProperty("审批状态（系统域）")
    private String approvalStatus;

    @ApiModelProperty("审批最后备注/退回备注")
    private String approvalRemark;

    /* ========================== 支付信息 ========================== */
    @ApiModelProperty("支付流水号（支付中心返回）")
    private String paymentTraceNo;

    @ApiModelProperty("支付重试次数")
    private Integer paymentAttempts;

    @ApiModelProperty("最后一次支付错误信息")
    private String lastPaymentError;

    @ApiModelProperty("支付中心原始响应（json/text）")
    private String paymentResponse;

    @ApiModelProperty("单据来源：1-中台，2-OA")
    private Integer source;
}
