package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * Author: daidemin
 * Date: 2024/10/17 11:00
 */
@ApiModel("报货以及收发货信息")
@Data
public class GoodsTransactionDTO {

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "有报货折扣：是、否")
    private String haveGoodsReportedDiscount;
    @ApiModelProperty(value = "报货折扣")
    private String goodsReportedDiscount;
    @ApiModelProperty(value = "折扣有效期 1：长期有效 2：定期有效")
    private String discountValidityPeriod;
    @ApiModelProperty(value = "折扣有效期起")
    private LocalDate discountValidityPeriodStart;
    @ApiModelProperty(value = "折扣有效期止")
    private LocalDate discountValidityPeriodEnd;
    @ApiModelProperty(value = "报货限制")
    private String goodsReportingLimit;

    @ApiModelProperty(value = "货物补贴状态")
    private String goodsSubsidyStatus;

    @ApiModelProperty(value = "报货负责人")
    private String merchandiser;

    @ApiModelProperty(value = "发货仓库")
    private String warehouse;

    @ApiModelProperty(value = "是否提价")
    private String priceIncrease;

    @ApiModelProperty(value = "冷链发货仓")
    private String coldChainWarehouse;

    @ApiModelProperty(value = "物流公司名称")
    private String logisticsCompanyName;

    @ApiModelProperty(value = "收货人")
    private String consignee;

    @ApiModelProperty(value = "收货人联系方式")
    private String consigneeContact;

    @ApiModelProperty(value = "收货人联系方式")
    private String consigneePhoneReserve;

    @ApiModelProperty(value = "收货地址省")
    private String deliveryAddressProvince;

    @ApiModelProperty(value = "收货地址市")
    private String deliveryAddressCity;

    @ApiModelProperty(value = "收货地址区")
    private String deliveryAddressDistrict;

    @ApiModelProperty(value = "收货地址")
    private String deliveryAddress;


}
