package com.elitesland.support.provider.constant;

/**
 * <p>
 * 功能说明:数据权限业务对象常量类
 * </p>
 *
 * @Author Darren
 * @Date 2024/05/07
 * @Version 1.0
 * @Content:
 */
public class SupportBusinessObjectConstants {

    /**
     * 基础域商品业务对象
     */
    public static final String SUPPORT_ITEM = "Support_Item:商品";

    /**
     * 基础域商品申请业务对象
     */
    public static final String SUPPORT_ITEM_APPLY = "Support_Item_Apply:商品申请";

    /**
     * 基础域商品审核业务对象
     */
    public static final String SUPPORT_ITEM_APPROVE = "Support_Item_Approve:商品审核单";

    /**
     * 基础域商品单位转换业务对象
     */
    public static final String SUPPORT_ITEM_UOM_CONV = "Support_Item_Uom_Conv:商品单位转换";

    /**
     * 基础域商品经营目录业务对象
     */
    public static final String SUPPORT_ITEM_BUSINESS = "Support_Item_Business:商品经营目录";

    /**
     * 基础域商品生命状态业务对象
     */
    public static final String SUPPORT_ITEM_LIFE_STATUS = "Support_Item_Life_Status:商品冻结";

    /**
     * 基础域商品状态配置业务对象
     */
    public static final String SUPPORT_ITEM_STATUS_CONFIG = "Support_Item_Status_Config:冻结场景配置";

    /**
     * 基础域商品关系业务对象
     */
    public static final String SUPPORT_ITEM_BOM = "Support_Item_Bom:商品关系";

    /**
     * 基础域商品关系业务对象
     */
    public static final String SUPPORT_ITEM_REPLACE = "Support_Item_Replace:替换商品配置";

    /**
     * 基础域公司业务对象
     */
    public static final String SUPPORT_OU = "Support_Ou:公司";

    /**
     * 基础域公司工厂业务对象
     */
    public static final String SUPPORT_OU_FACTORY = "Support_Ou_Factory:公司工厂";

    /**
     * 基础域门店申请业务对象
     */
    public static final String SUPPORT_STORE_APPROVE = "Support_Store_Approve:门店申请";

    /**
     * 基础域门店业务对象
     */
    public static final String SUPPORT_STORE = "Support_Store:门店";

    /**
     * 基础域品牌业务对象
     */
    public static final String SUPPORT_BRAND = "Support_Brand:品牌";

    /**
     * 基础域商品品类业务对象
     */
    public static final String SUPPORT_ITEM_CATE = "Support_Item_Cate:商品品类";

    /**
     * 基础域图片库文件夹业务对象
     */
    public static final String SUPPORT_ITEM_FILE = "Support_Item_File:图片库文件夹";

    /**
     * 基础域图片库图片业务对象
     */
    public static final String SUPPORT_ITEM_IMG = "Support_Item_Img:图片库图片";

    /**
     * 基础域商品品类属性业务对象
     */
    public static final String SUPPORT_ITEM_CATE_PROP = "Support_Item_Cate_Prop:商品品类属性";

    /**
     * 基础域商品价格业务对象
     */
    public static final String SUPPORT_PRI_PRICE = "Support_Pri_Price:价格";

    /**
     * 基础域商品价格审核业务对象
     */
    public static final String SUPPORT_PRICE_APPROVE = "Support_Price_Approve:价格审核";

    /**
     * 基础域结算路径业务对象
     */
    public static final String SUPPORT_TRANSACTION_PATH = "Support_Transaction_Path:结算路径";

    public static final String SUPPORT_ITEM_CATE_BRAND = "Support_Item_Cate_Brand:商品品类品牌关系";

    /**
     * 基础域商品
     * 操作编码，需保证全局唯一，建议格式：域缩写_模块名_功能名_操作名（如sys_common_org_tree）
     */
    public static final String SUPPORT_COMMON_SKU_PAGE = "support_common_sku_page";

    /**
     * 基础域公司-公司下拉查询
     */
    public static final String SUPPORT_COMMON_OU_LIST = "support_common_ou_list";

    /**
     * 基础域公司-公司分页列表
     */
    public static final String SUPPORT_COMMON_OU_PAGE = "support_common_ou_page";

    /**
     * 基础域公司工厂-公司工厂分页列表
     */
    public static final String SUPPORT_COMMON_OU_FACTORY_PAGE = "support_common_ou_factory_page";


    /******************************/
    /**
     * 销售域客户业务对象
     */
    public static final String CRM_CUST = "Crm_Cust:客户列表";

    /**
     * 系统域组织业务对象
     */
    public static final String SYS_ORG = "Sys_Org:组织";

    /**
     * 采购域供应商业务对象
     */
    //public static final String SYS_ORG = "Sys_Org:组织";


    public static final String SUPPORT_STORE_LIST = "support_store_list";

    public static final String SUPPORT_THALI_ITEM = "Support_Thali_Item:菜品";

    public static final String SUPPORT_THALI_ITEM_LIST = "support_thali_item_list";

    public static final String SUPPORT_STORE_APPROVE_LIST = "support_store_approve_list";

    public static final String SUPPORT_THALI_ITEM_BRAND = "Support_Thali_Item_Brand:菜品分类";

    public static final String SUPPORT_THALI_ITEM_BRAND_LIST ="support_thali_item_brand_list";

    public static final String SUPPORT_THALI_ITEM_BRAND_TREE_LIST ="support_thali_item_brand_tree_list";

    public static final String SUPPORT_ITEM_CATE_LIST = "support_item_cate_list";
    public static final String SUPPORT_ITEM_CATE_PAGE = "support_item_cate_page";

    public static final String SUPPORT_PRICE_LIST = "support_price_list";

    public static final String SUPPORT_PRICE_PAGE = "support_price_page";

    public static final String SUPPORT_PRICE_APPROVE_LIST = "support_price_approve_list";

    public static final String SUPPORT_PRICE_APPROVE_EXPORT = "support_price_approve_export";

    public static final String SUPPORT_INTER_SETTLE_PRICE_EXPORT = "support_inter_settle_price_export";

    public static final String SUPPORT_SALE_PRICE_EXPORT = "support_sale_price_export";

    public static final String SUPPORT_MAIN_PRICE_EXPORT = "support_main_price_export";

    public static final String SUPPORT_STORE_EXPORT= "support_store_export";

    public static final String SUPPORT_THALI_ITEM_EXPORT = "support_thali_item_export";

    /**
     * 区域
     */
    public static final String ORG_REGION = "SUPPORT_ORG_REGION:区域";
}
