package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/13
 * @Version 1.0
 * @Content:
 */

@Data
public class OrgOuComRpcDTO extends CustomFieldBaseModelVo implements Serializable {
    private static final long serialVersionUID = -8671634837452360130L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("公司ID")
    private Long id;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 公司简称
     */
    @ApiModelProperty(value = "公司简称")
    private String ouAbbr;

    /**
     * 公司类型 [UDC]ORG:OU_TYPE
     */
    @ApiModelProperty(value = "公司类型 [UDC]ORG:OU_TYPE")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE")
    private String ouType;
    private String ouTypeName;

    /**
     * 公司本位币
     */
    @ApiModelProperty(value = "公司本位币")
    private String currCode;

    /**
     * 公司本位币名称
     */
    @ApiModelProperty(value = "公司本位币名称")
    private String currName;

    /**
     * 公司对应的组织ID
     */
    @ApiModelProperty(value = "公司对应的组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 公司对应的组织编码
     */
    @ApiModelProperty(value = "公司对应的组织编码")
    private String buCode;

    /**
     * 地址号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("法人公司ID")
    private Long legalOuId;

    /**
     * 法人公司编号
     */
    @ApiModelProperty(value = "法人公司编号")
    private String legalOuCode;

    /**
     * 法人公司名称
     */
    @ApiModelProperty(value = "法人公司名称")
    private String legalOuName;

    @SysCode(sys = "yst-supp", mod = "OU_REGION")
    @ApiModelProperty("区域 [UDC]ORG:OU_REGION")
    private String region;
    @ApiModelProperty("区域名称 [UDC]ORG:OU_REGION")
    private String regionName;
    /**
     * 核算编码
     */
    @ApiModelProperty("核算编码")
    private String externalCode;

    /**
     * 纳税人类型
     */
    @ApiModelProperty(value = "纳税人类型")
    @SysCode(sys = "yst-supp", mod = "TAXPAYER_TYPE")
    private String taxpayerType;
    private String taxpayerTypeName;

    /**
     * 纳税人识别号
     */
    @ApiModelProperty(value = "纳税人识别号")
    private String taxerCode;
    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    @SysCode(sys = "yst-supp", mod = "INV_TYPE")
    private String invType;
    private String invTypeName;

    /**
     * 开户银行
     */
    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    /**
     * 银行账号
     */
    @ApiModelProperty(value = "银行账号")
    private String invBankAcc;

    /**
     * 开票抬头
     */
    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    /**
     * 开票联系人
     */
    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    /**
     * 开票联系人电话
     */
    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    /**
     * 开票地址
     */
    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    /**
     * 统一信用代码
     */
    @ApiModelProperty("统一信用代码")
    private String uniCertNo;
    /**
     * 工商登记号
     */
    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    @ApiModelProperty(value = "公司状态")
    @SysCode(sys = "yst-supp", mod = "OU_STATUS")
    private String ouStatus;
    private String ouStatusName;

    @ApiModelProperty(value = "公司归类")
    @SysCode(sys = "yst-supp", mod = "OU_TYPE2")
    private String ouType2;
    private String ouType2Name;

    /**
     * 税务登记号
     */
    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    @ApiModelProperty("是否管理库存 0：否 1：是")
    private Boolean invMgtFlag;

    @ApiModelProperty("是否启用工厂 0：否 1：是")
    private Boolean factoryEnableFlag;
}
