package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
@ApiModel(description = "地址薄保存参数")
public class OrgAddrRpcSaveParam implements Serializable {

    private static final long serialVersionUID = 4420653901428374811L;

    /**
     * ID
     */
    @ApiModelProperty("ID")
    private Long id;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty(value = "地址薄类型:[UDC]ORG:ADDR_TYPE", required = true)
    private String addrType;

    @ApiModelProperty(value = "地址薄名称", required = true)
    private String addrName;

    /**
     * 统一信用代码
     */
    @ApiModelProperty("统一信用代码")
    private String uniCertNo;

    @ApiModelProperty(value = "ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty(value = "ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty(value = "ES3")
    private String es3;

    /**
     * 数据来源  [UDC]ORG:ADDR_TYPE
     */
    @ApiModelProperty("数据来源   注意：更新时 请将对应的地址簿数据来源<[UDC]ORG:ADDR_TYPE>放入该列表中")
    private List<String> dataSources;

    /**
     * 地址信息保存列表
     */
    @ApiModelProperty("地址信息保存列表")
    List<OrgAddrAddressRpcSaveParam> orgAddrAddressSaveParams;

    /**
     * 银行信息保存列表
     */
    @ApiModelProperty("银行信息保存列表")
    List<OrgAddrBankAccRpcSaveParam> orgAddrBankAccSaveParams;

    /**
     * 证照信息保存列表
     */
    @ApiModelProperty("证照信息保存列表")
    List<OrgAddrQualifyRpcSaveParam> orgAddrQualifySaveParams;

}
