package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("公司DTO查询参数")
public class OrgOuRpcDtoParam implements Serializable {

    /**
     * 公司ID列表
     */
    @ApiModelProperty("公司ID列表")
    public List<Long> ouIds;

    /**
     * 公司编号列表
     */
    @ApiModelProperty("公司编号列表")
    public List<String> ouCodes;

    /**
     * 公司名称列表
     */
    @ApiModelProperty("公司名称列表")
    public List<String> ouNames;

    /**
     * 公司名称或编码 模糊查询
     */
    @ApiModelProperty("公司名称或编码 模糊查询")
    private String ouNameCode;

    /**
     * 公司状态
     */
    @ApiModelProperty("公司状态")
    public String ouStatus;

    /**
     * 核算编码
     */
    @ApiModelProperty("核算编码")
    private String externalCode;

    @ApiModelProperty("是否需要全部数据,0/默认：全部数据（除草稿和已逻辑删除的数据）；1：正常状态数据；2：已停用状态数据")
    private Integer allDataFlag;

    /**
     * 组织ID列表
     */
    @ApiModelProperty("组织ID列表")
    private List<Long> buIds;

    /**
     * 组织编号列表
     */
    @ApiModelProperty("组织编号列表")
    private List<String> buCodes;

}
