package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("联系人")
public class OrgContactRpcDTO implements Serializable {
    private static final long serialVersionUID = 6004274496843822765L;

    @ApiModelProperty("关联主表ID")
    private Long masId;

    @ApiModelProperty("联系人类型")
    private String type;

    @ApiModelProperty("联系人姓名")
    private String name;

    @ApiModelProperty("联系人手机号")
    private String mobile;

    @ApiModelProperty("地址编号")
    private Long addrNo;

    @ApiModelProperty("状态，ACTIVE：启用，CLOSED：停用")

    private String status;

    @ApiModelProperty("详细地址")
    private String detailAddress;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String county;

    @ApiModelProperty(value = "省份名称")
    private String provinceName;

    @ApiModelProperty(value = "城市名称")
    private String cityName;

    @ApiModelProperty(value = "区县名称")
    private String countyName;
}
