package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel("门店证照信息")
public class OrgStoreLicenseRpcDTO implements Serializable {
    private static final long serialVersionUID = 8083200018218753231L;
    @ApiModelProperty(value = "id")
    private Long id;
  
    @ApiModelProperty(value = "主表id")
    private Long masId;

    @ApiModelProperty(value = "证件编码")
    private String licenseCode;
    
    @ApiModelProperty(value = "证件名称")
    private String licenseName;
    
    @ApiModelProperty(value = "证件类型")
    private String licenseType;
    
    @ApiModelProperty(value = "经营范围")
    private String businessScope;


    @ApiModelProperty(value = "有效日期从")
    private LocalDateTime startTime;
    
    @ApiModelProperty(value = "有效日期至")
    private LocalDateTime endTime;
    //
    //issue date datetime DEFAULT NULL COMMENT '颁发日期',
    @ApiModelProperty(value = "颁发日期")
    private LocalDateTime issueDate;

    @ApiModelProperty(value = "统一社会信息代码")
    private String uniCertNo;

    @ApiModelProperty(value = "主体类型:0:个体工商户，1：企业")
    private Integer subjectType;


    @ApiModelProperty(value = "证照正面照片url")
    private String frontPicUrl;

    @ApiModelProperty(value = "证照反面照片url")
    private String backPicUrl;

    @ApiModelProperty(value = "证照图片url")
    private String picUrl;

    @ApiModelProperty(value = "经营项目")
    private String businessItems;

    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    @ApiModelProperty(value = "经营场所")
    private String businessPlace;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "证照正面照片文件编码")
    private String frontPicFileCode;

    @ApiModelProperty(value = "证照反面照片文件编码")
    private String backPicFileCode;

    @ApiModelProperty(value = "证照图片文件编码")
    private String picFileCode;
}
