package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 商品单位转换参数.
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/10 周五
 */
@Getter
@Setter
public class ItmItemUomConvDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 2657069792388985817L;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    @ApiModelProperty(value = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "基本单位")
    private String uom;

    @ApiModelProperty(value = "辅助单位")
    private String uom2;

    @ApiModelProperty(value = "销售单位")
    private String saleUom;

    @ApiModelProperty(value = "采购单位")
    private String purcUom;

    @ApiModelProperty(value = "定价单位")
    private String pricingUom;

    @ApiModelProperty(value = "拆零包装单位")
    private String disassemblyPack;

    @ApiModelProperty(value = "单位转换列表")
    private List<ItemUomConv> uomConvList;

    @Getter
    @Setter
    public static class ItemUomConv implements Serializable {
        @Serial
        private static final long serialVersionUID = 8666668868197863200L;

        @ApiModelProperty(value = "从单位")
        private String fromUom;

        @ApiModelProperty(value = "至单位")
        private String toUom;

        @ApiModelProperty(value = "单位转换系数")
        private BigDecimal ratio;

        @ApiModelProperty(value = "反向转换系数")
        private BigDecimal revertRatio;
    }
}
