package com.elitesland.support.provider.item.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/12/11
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itmItemBomComRpcParam", description = "商品BOM查询条件入参")
public class ItmItemBomComRpcParam implements Serializable {
    private static final long serialVersionUID = 6323917200499596005L;

    /*@ApiModelProperty(value = "商品编码")
    private String itemCode;*/

    @ApiModelProperty(value = "商品编码")
    private List<String> itemCodes;

    @ApiModelProperty(value = "产品结构关系类型")
    private String productStruType;

    @ApiModelProperty(value = "产品结构关系编码，支持模糊查询")
    private String productStruCode;

    @ApiModelProperty(value = "父ID, 默认为0")
    @JsonIgnore
    private Long pid;

    @ApiModelProperty(value = "父ID集合")
    @JsonIgnore
    private List<Long> pidList;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;
    @ApiModelProperty(value = "公司编码批量")
    private List<String> ouCodes;

    @ApiModelProperty("适用组织编号")
    private String buCode;
    @ApiModelProperty(value = "适用组织编号批量")
    private List<String> buCodes;

    @ApiModelProperty(value = "产品结构关系状态")
    private String bomStatus;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty(value = "商品类型 [UDC]yst-supp:ITEM_TYPE")
    private String itemType;

    @ApiModelProperty(value = "物料类型2 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    @ApiModelProperty("物料类型列表")
    private List<String> itemType2s;

    /**
     * 是否过滤临时组套商品(true 过滤，false 不过滤) 默认不过滤
     */
    @ApiModelProperty(value = "是否过滤临时组套商品(true 过滤，false 不过滤)")
    public Boolean filtTempComItem = false;

    /**
     * 是否过滤卡券商品(true 过滤，false 不过滤) 默认不过滤
     */
    @ApiModelProperty(value = "是否过滤卡券商品(true 过滤，false 不过滤)")
    public Boolean filtCouponItem = false;

}
