package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:允发期商品组主表和明细平级汇总展示
 * </p>
 *
 * @Author Darren
 * @Date 2023/08/09
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "allowShipItemGroupLevelRpcDTO", description = "允发期商品组主表和明细平级展示出参")
public class AllowShipItemGroupLevelRpcDTO implements Serializable {
    private static final long serialVersionUID = 4156044051139202636L;

    /**
     * 允发期商品组主表ID
     */
    @ApiModelProperty("允发期商品组主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 允发期商品组编码
     */
    @ApiModelProperty(value = "允发期商品组编码")
    private String code;

    /**
     * 允发期商品组名称
     */
    @ApiModelProperty(value = "允发期商品组名称")
    private String name;

    /**
     * 允发期商品组状态
     */
    @ApiModelProperty(value = "允发期商品组状态 [UDC]yst-supp:COMMON_STATUS")
    @SysCode(sys = "yst-supp", mod = "COMMON_STATUS")
    private String status;
    @ApiModelProperty("允发期商品组状态名称")
    private String statusName;

    /**
     * 允发期商品组类型
     */
    @ApiModelProperty(value = "允发期商品组类型 [UDC]yst-supp:ALLOW_SHIP_ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOW_SHIP_ITEM_TYPE")
    private String type;
    @ApiModelProperty("允发期商品组类型名称")
    private String typeName;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String allowDescribe;

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 品类编号
     */
    @ApiModelProperty(value = "品类编号")
    private String itemCateCode;
    /*@ApiModelProperty(value = "品类(SPU)全称")
    private String itemCateFullName;*/

    /**
     * 品牌编号
     */
    @ApiModelProperty(value = "品牌编号")
    private String brand;
   /* @ApiModelProperty(value = "品牌名称")
    private String brandName;*/

}
