package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/11/12
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel("经营目录商品SPU组套商品DTO")
public class ItmItemSpuBusinessRpcDTO implements Serializable {
    private static final long serialVersionUID = 3357055836491676004L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品经营目录ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("SPU的ID")
    private Long spuId;

    @ApiModelProperty(value = "SPU编号")
    private String spuCode;

    @ApiModelProperty(value = "经营组织")
    private String buCode;

    @ApiModelProperty(value = "商品来源组织")
    private String itemSource;

    @ApiModelProperty(value = "工厂ID")
    private Long factoryId;
    @ApiModelProperty(value = "工厂编码")
    private String factoryCode;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;


}
